;klawiatura 
;xxxx# - 4 cyfry kodu - otwarcie
;* [kod] # 1 [NOWY KOD] # [NOWY KOD] # - programowanie nowego kodu
;
;* [kod] # 2 1 - PRACA MONOSTABILNA
;* [kod] # 2 2 - PRACA BISTABILNA
;
;* [kod] # 3 - czas aktywny pracy monostabilnej 1-10sec
;
; POWRT DO KODU 1111 :
; 1 odlacz zasilania
; 2 zewrzec Z1 (MCLR do GND)
; 3 waczyc zasilania na 5 sec
; 4 wyczy zasilanie
; zdjac zwore Z1
;******************************************
;po resecie:
; kod=1111
; bistabilna
;******************************************
; organizacja pamici eeprom
;00 - pierwsza cyfra kodu
;01 - droga cyfra kodu
;02 - trzecia cyfra kodu
;03 - czwarta cyfra kodu
;04 - praca monostabilna=00 / bistabilna = FF
;05 - czas aktywny w trybie mosnostabilnym 0-15sec
;0F - 00 - przekaznik ON, FF- przekanik OFF
;definiowanie zmiennych
;#define IN_PROG GPIO, 1			;programowanie <=> 0
#define ADC GPIO, 0			;wejscie przetwornika ADC
#define DOOR GPIO, 1		;sterowanie przekanikiem
#define LED_R GPIO, 2		;LED R			;
#define LED_G GPIO, 4		;LED_G
#define BUZER_OUT GPIO, 5		;wyjscie BUZERA
#define RST GPIO, 3			; zwarcie  i wczenie zasilania przywraca kod 1111

#define dph 20h				; starszy bajt pomocniczy
#define dpl 21h				; mlodszy bajt pomocniczy
#define licznik h'22'			; pomocniczy licznik petli opoznienia
#define data_rd h'23'			; przepisanie danej z eeprom
#define stos h'24'			; pomocniczy rejestr zapamietujacy zmienne jak stos
#define key_cod h'25'			; kod klawiatury FF=no key; 0=0Ah; 0Ch=#; 0Bh=* 
#define F_data h'26'			; rej. przechowujacy zawartosc przeladowania timera
#define adress h'27'			;adres eeprom


;deklaracj typu procesora i formatu liczb
	list p=12F675			;okreslenie typu procesora
	#include p12f675.inc	;dolaczenie pliku z nazwami

;konfiguracja procesora
	__config _INTRC_OSC_NOCLKOUT &_MCLRE_OFF &_WDT_ON; gen wew. RC bez wyjscia 
									;wlaczone wejscie reset
									;watch dog wylaczony
	org 0
	goto start
	
	org 4
	goto timer_int	; (2CM)
start

;wylacz komparator
	movlw .7
	movwf cmcon

;konfiguracja linii i/o
	bsf status, rp0;bank1

	movlw h'09'					;0000 1001   0=wyjscie, 1=wejscie
	movwf trisio
	movlw h'36'					;0011 0110 rezystor pull up GP5 - prog
	movwf wpu
	bcf option_reg, 7				;zalacza wybrane w wpu rezystory do Vdd
							;GPPU=0 w rej option_reg 7 bit zalacza rezustory z rej. wpu
	bcf status, rp0 ;bank0

;wlacz adc
	;konfiguracja wejscia
	bsf status, rp0 ;bank1
	movlw b'11110000'	;	czestotliwo tj. RC, wejcie ANS1
	movwf ansel

	bcf status, rp0 ;bank0

	movlw b'00110001'	;	just - lewo; Vref=Vdd; ch0; ADC on
	movwf adcon0

	bcf intcon, gie	; zablokuj przerwania
	bcf pir1, adif	;zeruj flage przerwania

;ustawienia przerwania od timera0
	bsf status, rp0	;bank1
	movlw b'00001111'	;zliczanie cykli zegarowych bez preskalera b'00000100'
	movwf option_reg
	bcf status, rp0	;bank0
	clrf intcon
	clrf tmr0	;zeruje timer0 i preskaler
	bcf intcon, t0ie	;zezwolenie na int od timer0
	bsf intcon, gie	;ogolny bit zezwolenia na przerwania off
	bsf BUZER_OUT
;********************************************************
;program glowy

	bcf status, rp0	;bank0
	bsf intcon, gie	;ogolny bit zezwolenia na przerwania off
	movlw .25	;250	
	movwf F_data
	movwf tmr0
MENU0
	bsf LED_R
	bcf LED_G
	bcf DOOR
;
	movlw h'0F'			;
	call eeprom_read	;
	movwf key_cod
	btfsc key_cod, 0
	goto MENU0B
	bsf DOOR
	bcf LED_R
	bsf LED_G
MENU0B	
;
	call BUZER
	call BUZER
	call BUZER
	call delay1s
	call delay1s
	call delay1s
	btfss RST
	goto MENU0A
;
	movlw h'00'			;jeli eeprom pusty wpisuje 
	call eeprom_read	; adr 00=1
	movwf key_cod		; adr 01=1
	incf key_cod, 0	;	; adr 02=1
	btfss status, z	;	; adr 03=1
	goto MENU			; kod=1111
MENU0A
	movlw h'01'
	movwf data_rd
	movlw h'00'
	call eeprom_write	;pierwsza cyfra kodu
	movlw h'01'
	movwf data_rd
	movlw h'01'
	call eeprom_write	;druga cyfra kodu
	movlw h'01'
	movwf data_rd
	movlw h'02'
	call eeprom_write	;trzecia cyfra kodu
	movlw h'01'
	movwf data_rd
	movlw h'03'
	call eeprom_write	;czwarta cyfra kodu
;
MENU
	clrwdt
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto MENU
	call delay100ms
;*******************************
;	call decoder
;	call delay1s
;	goto MENU;
;*************************
	movlw h'0B'
	bcf status, z	;
	subwf key_cod, 0
	btfsc status, z
	goto INSTAL
;
	movlw h'0C'
	bcf status, z	;
	subwf key_cod, 0
	btfss status, z
	goto WORK
	goto MENU
;programowanie ustawien
INSTAL
	bcf LED_R
	bcf LED_G
	call TEST_COD
	btfsc key_cod, 7
	goto MENU		;falszywy kod
	clrwdt
;
INSTAL1:
;	clrwdt
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto INSTAL1
	call delay100ms
	bcf status, z	;
	movlw h'01'
	subwf key_cod, 0
	btfsc status, z
	goto PROGRAM	;wprowadzanie nowego kodu
	clrwdt
	bcf status, z	;
	movlw h'02'
	subwf key_cod, 0
	btfsc status, z
	goto MODE_SET	;!!!!!!!!!!!!!!!!!!
	clrwdt
	movlw h'03'
	subwf key_cod, 0
	btfsc status, z
	goto TIME_MON	;!!!!!!!!!!!!!!!!!
	call BUZER_LONG
	call BUZER_LONG
	goto MENU
;oczekuje wpisania kodu
WORK
	call TEST_COD1
	btfsc key_cod, 7
	goto WORK_END
;
	movlw h'04'			;sprawdza czy mono czy bistabilny
	call eeprom_read	; 
	movwf key_cod
	btfss key_cod, 7
	goto WORK_MONO		;praca monostabilna
;						bistabilny
	btfss LED_R
	goto WORK_BI_OFF
	bcf LED_R
	bsf LED_G
	bsf DOOR
;
	movlw h'00'	
	movwf data_rd
	movlw h'0F'
	call eeprom_write
;
	goto WORK_END
WORK_BI_OFF
	bsf LED_R
	bcf LED_G
	bcf DOOR
;
	movlw h'FF'	
	movwf data_rd
	movlw h'0F'
	call eeprom_write
;
	goto WORK_END
WORK_MONO				;praca monstabilna
	bcf LED_R
	bsf LED_G
	bsf DOOR
	movlw h'05'			; ile czasu ON w trybie mono
	call eeprom_read	; 
	andlw h'0f'			;od 0 do 15
	movwf key_cod
WORK_MONO1
	call delay1s
	decfsz key_cod, 1
	goto WORK_MONO1
	bsf LED_R
	bcf LED_G
	bcf DOOR
	goto WORK_END
;
WORK_END
	call delay1s
	goto MENU
;PROGRAMOWANIE NOWEGO KODU
PROGRAM
	bsf LED_R
	bsf LED_G
	clrwdt
PROG1
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto PROG1	
	movf key_cod, 0
	movwf data_rd
	movlw h'10'
	call eeprom_write	;pierwsza cyfra nowego kodu
	clrwdt
PROG2
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto PROG2
	movf key_cod, 0
	movwf data_rd
	movlw h'11'
	call eeprom_write	;druga cyfra nowego kodu	
	clrwdt
PROG3
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto PROG3
	movf key_cod, 0
	movwf data_rd
	movlw h'12'
	call eeprom_write	;trzecia cyfra nowego kodu	
	clrwdt
PROG4
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto PROG4
	movf key_cod, 0
	movwf data_rd
	movlw h'13'
	call eeprom_write	;czwarta cyfra nowego kodu	
	clrwdt
PROG5
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto PROG5
	call delay100ms
	movlw h'0C'			;OCZEKUJE KLAWISZA # 
	bcf status, z	;
	subwf key_cod, 0
	btfss status, z
	goto PROG_NOK
	call BUZER
	call BUZER
	clrwdt
PROG6
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto PROG6
	movlw h'10'			;
	call eeprom_read	;
	bcf status, z	;
	subwf key_cod, 0
	btfss status, z
	goto PROG_NOK
	clrwdt
PROG7
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto PROG7
	call delay100ms
	movlw h'11'			;
	call eeprom_read	;
	bcf status, z	;
	subwf key_cod, 0
	btfss status, z
	goto PROG_NOK
	clrwdt
PROG8
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto PROG8
	call delay100ms
	movlw h'12'			;
	call eeprom_read	;
	bcf status, z	;
	subwf key_cod, 0
	btfss status, z
	goto PROG_NOK
	clrwdt
PROG9
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto PROG9
	call delay100ms
	movlw h'13'			;
	call eeprom_read	;
	bcf status, z	;
	subwf key_cod, 0
	btfss status, z
	goto PROG_NOK
	clrwdt
PROG10
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto PROG10
	call delay100ms
	movlw h'0C'			;OCZEKUJE KLAWISZA # 
	bcf status, z	;
	subwf key_cod, 0
	btfss status, z
	goto PROG_NOK
	clrwdt
	call BUZER
	call BUZER
	call BUZER
	call BUZER
	call BUZER
	clrwdt
; zapis nowego kodu do eeprom
	movlw h'10'			;
	call eeprom_read	;
	movwf data_rd
	movlw h'00'
	call eeprom_write	;pierwsza cyfra kodu
	movlw h'11'			;
	call eeprom_read	;
	movwf data_rd
	movlw h'01'
	call eeprom_write	;druga cyfra kodu
	movlw h'12'			;
	call eeprom_read	;
	movwf data_rd
	movlw h'02'
	call eeprom_write	;trzecia cyfra kodu
	movlw h'13'			;
	call eeprom_read	;
	movwf data_rd
	movlw h'03'
	call eeprom_write	;czwarta cyfra kodu
	goto PROG_END
PROG_NOK
	call BUZER_LONG
	call BUZER_LONG
PROG_END
	bcf LED_G
	goto MENU
;
;programowanie tryb bistabilny / monostabilny
;* [kod] # 2 1 - PRACA MONOSTABILNA
;* [kod] # 2 2 - PRACA BISTABILNA
;praca monostabilna=00 / bistabilna = FF
MODE_SET
	bsf LED_R
	bsf LED_G
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto MODE_SET
	call delay100ms
	clrwdt
;
	movlw h'01'
	bcf status, z	;
	subwf key_cod, 0
	btfsc status, z
	goto MODE_SET_MONO
	movlw h'02'
	bcf status, z	;
	subwf key_cod, 0
	btfss status, z
	goto MODE_SET_NOK
	movlw h'ff'
	movwf data_rd
	movlw h'04'
	call eeprom_write	;pierwsza cyfra kodu
	goto MODE_SET_OK
MODE_SET_MONO
	movlw h'00'
	movwf data_rd
	movlw h'04'
	call eeprom_write	;pierwsza cyfra kodu	
MODE_SET_OK
	call BUZER
	call BUZER
	call BUZER
	goto MODE_SET_END
MODE_SET_NOK
	call BUZER_LONG
	call BUZER_LONG
MODE_SET_END
	bcf LED_G
	goto MENU
;
;* [kod] # 3 - czas aktywny pracy monostabilnej 1-10sec
TIME_MON
	bsf LED_R
	bsf LED_G
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto TIME_MON
	movf key_cod, 0
	movwf data_rd
	movlw h'05'
	call eeprom_write	;pierwsza cyfra nowego kodu
	call delay100ms
	call BUZER
	call BUZER
	call BUZER
	bcf LED_G
	goto MENU
;********************************************************
; funkcje pomocnicze
;obsluga przerwania od timera0
timer_int
	movwf stos; zapamietanie wartosci W
	bcf status, rp0	;bank0			(1CM)	
	bcf intcon, t0if	;zeruje flage przerwania (1CM)
	movf F_data, 0
	movwf tmr0	;	poczatkowa wartosc 204 + 2cykle na zaladowanie tmr0 (1CM)
	btfss BUZER_OUT	; 
	goto timer_int1
	bcf BUZER_OUT
	goto timer_int_end
timer_int1
	bsf BUZER_OUT
timer_int_end
	movf stos, 0; W:=stos zwrot wartosci W
	retfie						;(2CM)

;opoznienie o 10 ms
delay10
	movlw h'0b'		;1 bylo 0bh
delay10a
	movwf dph		;1
	movlw h'f2'		;1
delay10b
	movwf dpl	;przepisuja W do dpl
	decfsz dpl,0		;1 dekrement, wynik do W, jesli 0 pomin next instr.
	goto delay10b	;1
	movlw dph	;	wpisz do W dph
	decfsz dph,0	;1 zmniejsz dph, wynik do W, jesli 0 pomin next instr.
	goto delay10a	;1
	return	
;opoznienie o 100ms
delay100ms
	movwf stos 	;zapamietuje W na stosie
	movlw .10
	movwf licznik
	call delay10
	decfsz licznik, f
	goto $-2
	movf stos,0	;oddaje wartosc W
	return
;opoznienie o 1 sek
delay1s
	movwf stos 	;zapamietuje W na stosie
	movlw .100
	movwf licznik
	call delay10
	decfsz licznik, f
	goto $-2
	movf stos,0	;oddaje wartosc W
	clrwdt
	return
;odczyt z eeprom spod adr. W, dana zapisana do W
eeprom_read
	bsf status, rp0 ;bank1
	movwf eeadr		;wpisanie adresu z w eeadr
	bsf eecon1, rd	;odczyt z eeprom
	movf eedata, w	;przepisanie odczytanej danej do w
	bcf status, rp0 ;bank0
	return
;zapis do eeprom spod adresu W (dane data_rd)
eeprom_write
	;movwf data_rd	;przepisanie dnych z W do DATA_RD
				;zapis nowych danych do eeprom pod adr. 0
	bsf status, rp0 ;bank1
	;clrw			;w:=0 dres
	movwf eeadr		;wpisanie adresu z w eeadr
	movf data_rd, 0	;dane do zapisu wyslane do W
	movwf eedata	;wyslanie danych do eedata
	bsf eecon1, wren	;zezwolenie na zapis
	movlw h'55'
	movwf eecon2
	movlw h'aa'
	movwf eecon2
	bsf eecon1, wr	;rozpoczecie zapisu
	btfsc eecon1, wr	;oczekiwanie na koniec zapisu
	goto $-1
	bcf eecon1, wren	;wyl. zezwolenia na zapis
	bcf status, rp0	;powrot do bank0
	return

;jednokrotny sygnal dzwiekowy
BUZER
	bcf status, rp0
	bsf intcon, t0ie	;zezwolenie na int od timer0
	call delay100ms
	bsf BUZER_OUT
	bcf intcon, t0ie	;zezwolenie na int od timer0
	call delay100ms
	return
;jednokrotny sygnal dzwiekowy
BUZER_LONG
	bcf status, rp0
	bsf intcon, t0ie	;zezwolenie na int od timer0
	call delay100ms
	call delay100ms
	call delay100ms
	bsf BUZER_OUT
	bcf intcon, t0ie	;zezwolenie na int od timer0
	call delay100ms
	clrwdt
	return
;odczyt klawiszy
; if FF <=> no KEY
; if key_cod.7=1 <=> 2
; if key_cod-076h>0 <=> 5
; if key_cod-071h>0 <=> 8
; if key_cod-06Ah>0 <=> 0
; if key_cod-060h>0 <=> 1
; if key_cod-04Ah>0 <=> 3
; if key_cod-03Fh>0 <=> 4
; if key_cod-033h>0 <=> 7
; if key_cod-026h>0 <=> *
; if key_cod-019h>0 <=> 6
; if key_cod-08h>0 <=> 9
; else #
KEY_RD
	bcf status, rp0
	bsf adcon0, go	; start konwersji ADC
	btfsc adcon0, go	; czy koniec konwersji
	goto $-1
	btfss adresh, 7	
	goto KEY_RD0
	btfss adresh, 6
	goto KEY_RD0
	movlw h'ff'	;key-cod - brak nacisniecia klawisza
	movwf key_cod
	goto KEY_RD_END
KEY_RD0
	call delay10
;	call delay10;
;	call delay10;
	bcf status, rp0
	bsf adcon0, go	; start konwersji ADC
	btfsc adcon0, go	; czy koniec konwersji
	goto $-1
	btfss adresh, 7
	goto KEY_RD1
	movlw h'02'	;key-cod - 2 ok
	movwf key_cod
	goto KEY_RD1C
KEY_RD1
	movlw h'ff'	;key-cod - brak nacisniecia klawisza
	movwf key_cod
	bcf status, c
	movf adresh, 0
	sublw h'78'	; bylo 76!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	btfsc status, c	;
	goto KEY_RD11
	movlw h'05'	;key-cod - 5
	movwf key_cod
	goto KEY_RD1C
KEY_RD11
	bcf status, c
	movf adresh, 0
	sublw h'71'
	btfsc status, c	;
	goto KEY_RD12
	movlw h'08'	;key-cod - 8
	movwf key_cod
	goto KEY_RD1C
KEY_RD12
	bcf status, c
	movf adresh, 0
	sublw h'6E'		;bylo 6A !!!!!!!!!!!!!!!!!!!!!!!
	btfsc status, c	;
	goto KEY_RD13
	movlw h'0A'	;key-cod - 0
	movwf key_cod
	goto KEY_RD1C
KEY_RD13
	bcf status, c
	movf adresh, 0
	sublw h'60'
	btfsc status, c	;
	goto KEY_RD14
	movlw h'01'	;key-cod - 1
	movwf key_cod
	goto KEY_RD1C
KEY_RD14
	bcf status, c
	movf adresh, 0
	sublw h'4A'
	btfsc status, c	;
	goto KEY_RD15
	movlw h'03'	;key-cod - 3
	movwf key_cod
	goto KEY_RD1C
KEY_RD15
	bcf status, c
	movf adresh, 0
	sublw h'45'			;bylo 3F !!!!!!!!!!!!!!!!!!
	btfsc status, c	;
	goto KEY_RD16
	movlw h'04'	;key-cod - 4
	movwf key_cod
	goto KEY_RD1C
KEY_RD16
	bcf status, c
	movf adresh, 0
	sublw h'33'       ;
	btfsc status, c	;
	goto KEY_RD17
	movlw h'07'	;key-cod - 7
	movwf key_cod
	goto KEY_RD1C
KEY_RD17
	bcf status, c
	movf adresh, 0
	sublw h'26'
	btfsc status, c	;
	goto KEY_RD18
	movlw h'0B'	;key-cod - *
	movwf key_cod
	goto KEY_RD1C
KEY_RD18
	bcf status, c
	movf adresh, 0
	sublw h'21'				;bylo 19
	btfsc status, c	;
	goto KEY_RD19
	movlw h'06'	;key-cod - 6 OK
	movwf key_cod
	goto KEY_RD1C
KEY_RD19
	bcf status, c
	movf adresh, 0
	sublw h'08'
	btfsc status, c	;
	goto KEY_RD20
	movlw h'09'	;key-cod - 9 OK !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	movwf key_cod
	goto KEY_RD1C
KEY_RD20
	movlw h'0C'	;key-cod - #
	movwf key_cod
KEY_RD1c
	call BUZER	;sygnal dzwiekowy
KEY_RD2
	call delay10
	bsf adcon0, go	; start konwersji ADC
	btfsc adcon0, go	; czy koniec konwersji
	goto $-1
	btfsc adresh, 7
;	goto KEY_RD2	;oczekuje na puszczenie klawisza
	btfss adresh, 6
	goto KEY_RD2	;oczekuje na puszczenie klawisza
KEY_RD_END
	return
;****************************************************************************
;funkcja zwiekszajaca o 4 adres eprom tyle razy ile jest W > adres=W(adres+4)
ADR_INC
	movwf dpl	;dpl=W
	movlw h'04'
	addwf adress, 0
	movwf adress
	decf	dpl, 0
	btfss status, z
	goto ADR_INC
	return

ADR_RD
	movlw h'03'
	subwf adress, 0
ADR_RD1
	movwf adress
	call BUZER
	call delay100ms
	call delay100ms
	call delay100ms
	movlw h'04'
	subwf adress, 0
	btfss status, z
	goto ADR_RD1
	return
;***************************************************************************
; beep tyle razy jaki by kod klawisza
decoder
	call BUZER_LONG
	bcf status, z
	decf key_cod, 0	;
	btfsc status, z	;
	goto DECODER_END
	movwf key_cod
	goto decoder
DECODER_END
	return
;test KOD
; jesli kod=ok <=> key_cod=0
; jeli kod nok <=> key_cod=ff
TEST_COD
	clrwdt
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto TEST_COD
TEST_COD1
	movlw h'00'			;jeli eeprom pusty wpisuje 
	call eeprom_read	; adr 00=1
	bcf status, z	;
	subwf key_cod, 0
	btfss status, z
	goto KOD_FAULT1
	clrwdt
KOD1
;	clrwdt
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto KOD1
	call delay100ms
	movlw h'01'			;jeli eeprom pusty wpisuje 
	call eeprom_read	; adr 01=1
	bcf status, z	;
	subwf key_cod, 0
	btfss status, z
	goto KOD_FAULT2
	clrwdt
KOD2
;	clrwdt
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto KOD2
	call delay100ms
	movlw h'02'			;jeli eeprom pusty wpisuje 
	call eeprom_read	; adr 02=1
	bcf status, z	;
	subwf key_cod, 0
	btfss status, z
	goto KOD_FAULT3
	clrwdt
KOD4
;	clrwdt
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto KOD4
	call delay100ms
	movlw h'03'			;jeli eeprom pusty wpisuje 
	call eeprom_read	; adr 03=1
	bcf status, z	;
	subwf key_cod, 0
	btfss status, z
	goto KOD_FAULT4
	clrwdt
KOD5
;	clrwdt
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto KOD5
	call delay100ms
	movlw h'0C'			;OCZEKUJE KLAWISZA # 
	bcf status, z	;
	subwf key_cod, 0
	btfss status, z
	goto KOD_FAULT
;
	call BUZER
	call BUZER
	call BUZER
	clrf key_cod
	goto KOD_END
KOD_FAULT1
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto KOD_FAULT1
	call delay100ms
KOD_FAULT2
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto KOD_FAULT2
	call delay100ms
KOD_FAULT3
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto KOD_FAULT3
	call delay100ms
KOD_FAULT4
	call delay10
	call KEY_RD
	btfsc key_cod, 7
	goto KOD_FAULT4
	call delay100ms
KOD_FAULT
	call BUZER_LONG
	call BUZER_LONG
	movlw h'ff'
	movwf key_cod
KOD_END
	call delay100ms
	return

	end
